class BankAccount:
    def __init__(self, account_number, account_holder, account_type, balance):
        self.account_number = account_number
        self.account_holder = account_holder
        self.account_type = account_type
        self.balance = balance

    def deposit(self, amount):
        if amount > 0:
            self.balance += amount
            return True
        return False

    def withdraw(self, amount):
        if 0 < amount <= self.balance:
            self.balance -= amount
            return True
        return False

    def get_balance(self):
        return self.balance

    def __str__(self):
        return f"Account Number: {self.account_number}, Holder: {self.account_holder}, Type: {self.account_type}, Balance: {self.balance:.2f}"

    @staticmethod
    def load_accounts(filename):
        accounts = []
        try:
            with open(filename, "r") as f:
                for line in f:
                    parts = line.strip().split(",")
                    if len(parts) == 4:
                        acc_num, acc_holder, acc_type, balance = parts
                        try:
                            balance = float(balance)
                            accounts.append(BankAccount(acc_num, acc_holder, acc_type, balance))
                        except ValueError:
                            continue
        except FileNotFoundError:
            pass
        return accounts

    @staticmethod
    def save_accounts(filename, accounts):
        with open(filename, "w") as f:
            for acc in accounts:
                f.write(f"{acc.account_number},{acc.account_holder},{acc.account_type},{acc.balance}\n")
